// binarySearch.java
// Prezentuje rekurencyjny alagorytm wyszukiwania binarnego
// Aby wykona program: C>java BinarySearchApp
////////////////////////////////////////////////////////////////
class ordArray
   {
   private long[] a;                 // odwoanie do tablicy a
   private int nElems;               // ilo elementw tablicy
   //-----------------------------------------------------------
   public ordArray(int max)          // konstruktor
      {
      a = new long[max];             // tworzymy tablic
      nElems = 0;
      }
   //-----------------------------------------------------------
   public int size()
      { return nElems; }
   //-----------------------------------------------------------
   public int find(long searchKey)
      {
      return recFind(searchKey, 0, nElems-1);
      }
   //-----------------------------------------------------------
   private int recFind(long searchKey, int lowerBound,
                                         int upperBound)
      {
      int curIn;

      curIn = (lowerBound + upperBound ) / 2;
      if(a[curIn]==searchKey)
         return curIn;              // znaleziony
      else if(lowerBound > upperBound)
         return nElems;             // nie mona znale
      else                          // dzielimy zakres
         {
         if(a[curIn] < searchKey)   // w grnej powce zakresu
            return recFind(searchKey, curIn+1, upperBound);
         else                       // w dolnej powce zakresu
            return recFind(searchKey, lowerBound, curIn-1);
         }  // koniec klauzuli else dzielcej zakres
      }  // koniec metody recFind()
   //-----------------------------------------------------------
   public void insert(long value)    // zapis elementu w tablicy
      {
      int j;
      for(j=0; j<nElems; j++)        // okrelamy gdzie go zapisa
         if(a[j] > value)            // (wyszukiwanie liniowe)
            break;
      for(int k=nElems; k>j; k--)    // wiksze elementy przesuwamy w gr
         a[k] = a[k-1];
      a[j] = value;                  // wstawiamy element
      nElems++;                      // powikszamy wielko tablicy
      }  // end insert()
   //-----------------------------------------------------------
   public void display()             // wywietlenie zawartoci tablicy
      {
      for(int j=0; j<nElems; j++)       // dla kadego elementu tablicy,
         System.out.print(a[j] + " ");  // wywietlamy go
      System.out.println("");
      }
   //-----------------------------------------------------------
   }  // koniec klasy ordArray
////////////////////////////////////////////////////////////////
class BinarySearchApp
   {
   public static void main(String[] args)
      {
      int maxSize = 100;             // wielko tablicy
      ordArray arr;                  // odwoanie do tablicy
      arr = new ordArray(maxSize);   // tworzymy tablic

      arr.insert(72);                // zapisujemy elementy
      arr.insert(90);
      arr.insert(45);
      arr.insert(126);
      arr.insert(54);
      arr.insert(99);
      arr.insert(144);
      arr.insert(27);
      arr.insert(135);
      arr.insert(81);
      arr.insert(18);
      arr.insert(108);
      arr.insert(9);
      arr.insert(117);
      arr.insert(63);
      arr.insert(36);

      arr.display();                 // wywietlamy tablic

      int searchKey = 27;            // szukamy elementu
      if( arr.find(searchKey) != arr.size() )
         System.out.println("Znaleziono " + searchKey);
      else
         System.out.println("Nie znaleziono " + searchKey);
      }  // koniec metody main()
   }  // koniec klasy BinarySearchApp
////////////////////////////////////////////////////////////////
